<?php
// =========================================================================
// subdiretor_control_presenca.php - Painel de Gestão de Seminários (Subdireção Pedagógica)
// Controla a abertura e fecho da marcação de presença diária.
// =========================================================================
 
// --- CONFIGURAÇÃO DE CONEXÃO ---
define('DB_HOST', 'localhost');
define('DB_PORT', '3307');
define('DB_NAME', 'sismag'); 
define('DB_USER', 'root');
define('DB_PASS', '');
 
$pdo = null;
$mensagem = '';
$data_hoje = date('Y-m-d');

try {
    $dsn = "mysql:host=" . DB_HOST . ";port=" . DB_PORT . ";dbname=" . DB_NAME . ";charset=utf8";
    $pdo = new PDO($dsn, DB_USER, DB_PASS);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    $pdo->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
} catch (PDOException $e) {
    die("ERRO DE CONEXÃO COM A BASE DE DADOS 'sismag': " . $e->getMessage());
}

// --- LÓGICA DE ABRIR/FECHAR MARCAÇÃO ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['acao_presenca'])) {
    
    $seminario_id = (int)$_POST['seminario_id'];
    $data_seminario = $_POST['data_seminario']; 
    $acao = $_POST['acao_presenca']; 
    
    if ($data_seminario != $data_hoje) {
         $mensagem = "<p style='color:red;'>Erro: A ação só pode ser realizada para a data de hoje ($data_hoje).</p>";
    } else {
        try {
            // Insere/Atualiza a linha de controlo (professor_id = 0)
            $stmt = $pdo->prepare("
                INSERT INTO presencas_seminario 
                (seminario_id, professor_id, data_presenca, data_registo, status_marcador) 
                VALUES (?, 0, ?, NOW(), ?)
                ON DUPLICATE KEY UPDATE 
                status_marcador = VALUES(status_marcador), data_registo = NOW()
            ");
            $stmt->execute([$seminario_id, $data_seminario, $acao]);

            $status_display = ($acao == 'ABRIR') ? 'ABERTA' : 'FECHADA';
            $mensagem = "<p style='color:green; font-weight:bold;'>Sucesso! Marcação de Presença para hoje ($data_hoje) foi $status_display.</p>";
            
        } catch (PDOException $e) {
            $mensagem = "<p style='color:red;'>Erro ao alterar o status: " . $e->getMessage() . "</p>";
        }
    }
}

// --- LÓGICA DE CADASTRO DE NOVO SEMINÁRIO (simplificada) ---
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['cadastrar_seminario'])) {
    $nome = $_POST['nome_seminario'];
    $data_inicio = $_POST['data_inicio'];
    $data_fim = $_POST['data_fim'];
    $ano = (int)date('Y', strtotime($data_inicio));
    // Calculo básico do trimestre (1-3: T1, 4-6: T2, 7-9: T3, 10-12: T4)
    $trimestre = ceil((int)date('n', strtotime($data_inicio)) / 3); 

    try {
        $data1 = new DateTime($data_inicio);
        $data2 = new DateTime($data_fim);
        $diff = $data1->diff($data2);
        $num_dias = $diff->days + 1; 

        $stmt = $pdo->prepare("
            INSERT INTO seminarios (nome_seminario, ano, trimestre, data_inicio, data_fim, num_dias_seminario) 
            VALUES (?, ?, ?, ?, ?, ?)
        ");
        $stmt->execute([$nome, $ano, $trimestre, $data_inicio, $data_fim, $num_dias]);
        $mensagem = "<p style='color:green; font-weight:bold;'>Seminário '{$nome}' cadastrado com sucesso! ($num_dias dias).</p>";
    } catch (PDOException $e) {
        $mensagem = "<p style='color:red;'>Erro ao cadastrar seminário: Já existe um seminário com esse nome/período. " . $e->getMessage() . "</p>";
    }
}

// --- BUSCA SEMINÁRIOS ATIVOS E STATUS DE HOJE ---
$stmt_seminarios = $pdo->prepare("
    SELECT s.*, p.status_marcador
    FROM seminarios s
    LEFT JOIN presencas_seminario p ON s.id = p.seminario_id 
        AND p.data_presenca = ? 
        AND p.professor_id = 0 
    WHERE ? BETWEEN s.data_inicio AND s.data_fim
    ORDER BY s.data_inicio ASC
");
$stmt_seminarios->execute([$data_hoje, $data_hoje]);
$seminarios_ativos = $stmt_seminarios->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt">
<head>
    <meta charset="UTF-8">
    <title>Controlo de Presença - Subdireção</title>
    <style>
        /* ... Estilos CSS ... */
        body { font-family: Arial, sans-serif; background-color: #f4f4f4; margin: 20px; }
        .container { max-width: 900px; margin: 0 auto; background-color: #fff; padding: 25px; border-radius: 8px; box-shadow: 0 0 15px rgba(0,0,0,0.1); }
        h1 { text-align: center; color: #dc3545; border-bottom: 3px solid #dc3545; padding-bottom: 10px; margin-bottom: 25px; }
        h2 { color: #007bff; margin-top: 30px; border-bottom: 1px solid #ccc; padding-bottom: 5px; }
        .seminario-card { border: 1px solid #ccc; padding: 15px; margin-bottom: 15px; border-radius: 6px; background-color: #f9f9f9; }
        .status-aberto { color: green; font-weight: bold; }
        .status-fechado { color: red; font-weight: bold; }
        .form-group { display: flex; gap: 10px; align-items: center; }
        .form-group button { padding: 10px 15px; border: none; border-radius: 4px; cursor: pointer; color: white; }
        .open-btn { background-color: #007bff; }
        .close-btn { background-color: #dc3545; }
        input[type="text"], input[type="date"] { padding: 10px; border: 1px solid #ccc; border-radius: 4px; box-sizing: border-box; width: 100%; margin-bottom: 10px; }
        /* ... Fim dos Estilos CSS ... */
    </style>
</head>
<body>
    <div class="container">
        <h1>Controlo Diário de Presença em Seminários</h1>
        <p style="text-align: center;">**Data Atual:** <?= date('d/m/Y') ?>. O status só pode ser alterado para a data de hoje.</p>

        <?= $mensagem ?>

        <h2>1. Cadastrar Novo Seminário</h2>
        <form action="" method="post">
            <input type="text" name="nome_seminario" placeholder="Nome do Seminário de Capacitação" required>
            <div class="form-group" style="gap: 20px;">
                <div style="flex: 1;"><input type="date" name="data_inicio" required></div>
                <div style="flex: 1;"><input type="date" name="data_fim" required></div>
                <button type="submit" name="cadastrar_seminario" style="margin: 0; background-color: #5cb85c;">Cadastrar</button>
            </div>
        </form>


        <h2>2. Gerir Marcação de Presença (Hoje)</h2>
        <?php if (empty($seminarios_ativos)): ?>
            <p style="color: gray;">Nenhum seminário de capacitação ativo para a data de hoje.</p>
        <?php endif; ?>

        <?php foreach ($seminarios_ativos as $seminario): 
            $status = $seminario['status_marcador'] ?? 'FECHADO';
            $status_class = ($status == 'ABERTO') ? 'status-aberto' : 'status-fechado';
        ?>
            <div class="seminario-card">
                <p><strong>Seminário:</strong> <?= htmlspecialchars($seminario['nome_seminario']) ?> (<?= $seminario['num_dias_seminario'] ?> dias)</p>
                <p><strong>Período:</strong> <?= date('d/m/Y', strtotime($seminario['data_inicio'])) ?> a <?= date('d/m/Y', strtotime($seminario['data_fim'])) ?></p>
                <p><strong>Status Atual da Marcação:</strong> <span class="<?= $status_class ?>"><?= $status ?></span></p>

                <form action="" method="post" class="form-group">
                    <input type="hidden" name="seminario_id" value="<?= $seminario['id'] ?>">
                    <input type="hidden" name="data_seminario" value="<?= $data_hoje ?>">
                    
                    <?php if ($status == 'FECHADO'): ?>
                        <button type="submit" name="acao_presenca" value="ABRIR" class="open-btn" style="flex: 1;">
                            ABRIR MARCAÇÃO DE PRESENÇA
                        </button>
                    <?php else: ?>
                        <button type="submit" name="acao_presenca" value="FECHAR" class="close-btn" style="flex: 1;">
                            FECHAR MARCAÇÃO DE PRESENÇA (Fim do Expediente)
                        </button>
                    <?php endif; ?>
                </form>
            </div>
        <?php endforeach; ?>
    </div>
</body>
</html>
<?php
